TITLE   'Magnetostatic Field Energy'				  { ex145.pde }
SELECT   errlim=1e-4	spectral_colors				
COORDINATES   ycylinder( 'r', 'z')
VARIABLES   A_phi
DEFINITIONS
   r1=0.1   r2=0.12   z0=0.01   L=1.0	
   mu0=4*pi*1e-7   Jd=1e4   mu=mu0   J_phi        	
   Br=-dz(A_phi)   Bz=1/r*dr(r*A_phi)
   B=vector( Br, Bz)   Bm=magnitude( B)
   Hr=Br/mu   Hz=Bz/mu   H=B/mu   Hm=Bm/mu
   W=vol_integral( 0.5*Bm*Hm) 			{ Field energy }
   flux1=surf_integral( Bz, 'radius1')		{ Flux through coil }
   flux2=surf_integral( Bz, 'radius2')		{ Flux through coil }
   J0=Jd*(r2-r1)*(2*z0)				     	{ Current }
   W1=flux1*J0/2   W2=flux2*J0/2			{ Electric work }
EQUATIONS
   dz( Hr)- dr( Hz)=J_phi
BOUNDARIES
region 'domain' J_phi=0		
   start  'outer'  (0,-L)  	value(A_phi)=0
   line to (2*L,-L)  to (2*L, L)  to (0, L) to finish
region 'coil'	J_phi=Jd         			{ Current density }
   start(r1,-z0) line to (r2,-z0) to (r2,z0) to (r1,z0) to finish
feature
   start 'radius1' (0,0) line to (r1, 0)
   start 'radius2' (0,0) line to (r2, 0)
PLOTS
   contour( 2*pi*r* 0.5* Bm^2/mu) log  report( W) report( W1) report( W2)
END
